/* Adobe.TestHandleTeask.js */

define([
	"lodash", "lib/tasks", "src/math/mathUtils", 
	"src/math/vec2", "src/math/mat3"
	], 
function(
	lodash, libtasks, mathUtils, 
	vec2, mat3
) {
	"use strict";

	return {
		about                   : "Tests handle tasks.",
		description             : "Internal testing behavior.",
		uiName                  : "Test Handle Tasks",
		defaultArmedForRecordOn : false,
		hideInBehaviorList      : true,

		defineParams : function () {
			return [
				{
					id: "moveTargets", type: "handle", uiName: "Move To",
					dephault: { match: "//Adobe.Dragger.Draggable" }
				},
				{id:"warpReferenceFrame", type:"checkbox", uiName:"Using warp reference frame?", dephault:false},
				{id:"usePositionX", type:"checkbox", uiName:"Use Position X",	dephault:false},
				{id:"positionX", type:"slider", uiName:"$$$/private/animal/Behavior/TestHandleTask/Param/PositionX=Position X",	precision:1, dephault:0},
				{id:"usePositionY", type:"checkbox", uiName:"Use Position Y",	dephault:false},
				{id:"positionY", type:"slider", uiName:"$$$/private/animal/Behavior/TestHandleTask/Param/PositionY=Position Y",	precision:1, dephault:0},
				{id:"useUniformScale", type:"checkbox", uiName:"Use Scale",	dephault:false},
				{id:"uniformScale", type:"slider", uiName:"$$$/private/animal/Behavior/TestHandleTask/Param/Scale=Scale",		precision:1, uiUnits:"%", dephault:100},
				{id:"useRotation", type:"checkbox", uiName:"Use Rotation",	dephault:false},
				{id:"rotation", type:"angle", uiName:"$$$/private/animal/Behavior/TestHandleTask/Param/Rotation=Rotation", precision:0, dephault:0}
			];
		},
		
		onCreateBackStageBehavior : function (/* self */) {
			return {
				order : 0.0,
				importance : 1.0
			};
		},
		
		onCreateStageBehavior : function (self/*, args */) {
		},
		
		onAnimate : function (self, args) { 
			var x = args.getParam("positionX"),
				y = args.getParam("positionY"),
				uniformScale = args.getParam("uniformScale") * 0.01,
				angle = args.getParam("rotation"),
				moveTargets = args.getParam("moveTargets");

			var taskParams = {};
			if (x !== 0) taskParams.x = x;
			// if (args.getParam("usePositionX")) taskParams.x = x;
			if (y !== 0) taskParams.y = y;
			if (uniformScale !== 1) { 
				taskParams.xScale = uniformScale;
				taskParams.yScale = uniformScale;
			}
			if (angle !== 0) taskParams.angle = mathUtils.rad(angle);

			var moveTo = new libtasks.MoveTo(taskParams);

			moveTargets.forEach(function (h) {
				libtasks.handle.attachTask(h, moveTo, 1);
			});
		}
			
	}; // end of object being returned
});
